
/*============================================================================
 Name        : serial.h
 Author      :
 Date  	     : 2015.9
 Copyright   : ZKSoftware Inc.
 Description : Linux C
 ============================================================================*/
#ifndef _SERIAL_H_
#define _SERIAL_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>	//fork()
#include <time.h>

#ifndef GCC_PACKED
#define GCC_PACKED		__attribute__((packed))
#endif

#define MAX_BYTE (1024*5+128)   //recv data size 5k + 128
#define MAX_SEND (1024*4+128)	//send data size 4k + 128
#define MAX_DATA (1024*3)
#define CLEAN_DATA (1024*4)
#define RECV_SIZE_USB	(1024 * 129)
#define FIRMWARE_SIZE (1024*1024)

enum __ARCA_BAUDRATE
{
    V10_B0=0,				    /* used to drop DTR */
    V10_B50,				    /* 50 baud */
    V10_B75,				    /* 75 baud */
    V10_B110,				    /* 110 baud */
    V10_B134,				    /* 134.5 baud */
    V10_B150,				    /* 150 baud */
    V10_B200,				    /* 200 baud */
    V10_B300,				    /* 300 baud */
    V10_B600,				    /* 600 baud */
    V10_B1200,			     	/* 1200 baud */
    V10_B1800,			    	/* 1800 baud */
    V10_B2400,			     	/* 2400 baud */
    V10_B4800,			     	/* 4800 baud */
    V10_B9600,			     	/* 9600 baud */
    V10_B19200,			     	/* 19200 baud */
    V10_B38400,			     	/* 38400 baud */
    V10_B57600,			     	/* 57,600 baud */
    V10_B115200,		     	/* 115,200 baud */
    V10_NUM_BAUDRATES		    /* the number of entries */    
};

enum __ARCA_DATASIZE
{
    V10_5BIT=0,
    V10_6BIT,
    V10_7BIT,
    V10_8BIT,
    V10_NUM_DATASIZES		     /* number of datasize values */
};

enum __ARCA_PARITY_FLAGS
{
    V10_NONE=0,			     /* disable parity bit */
    V10_EVEN,			     /* even parity */
    V10_ODD,			     /* odd parity */
    V10_IGNORE			     /* use parity but do not test it */
};

/* Serial port operation */
typedef int (*serial_init_func_t)(int, int, int, int, char*);
typedef int (*serial_read_func_t)(void);
typedef int (*serial_write_func_t)(int);
typedef int (*serial_poll_func_t)(void);
typedef int (*serial_flush_input_func_t)(void);
typedef int (*serial_flush_output_func_t)(void);
typedef void (*serial_free_func_t)(void);
typedef int (*serial_tcdrain_func_t)(void);
typedef int (*serial_get_lsr_func_t)(void);
typedef int (*serial_write_buf_func_t)(unsigned char*,int);
typedef int (*serial_read_buf_func_t)(unsigned char*,int);
typedef struct {
	serial_init_func_t init;

	serial_read_func_t read;
	serial_write_func_t write;

	serial_poll_func_t poll;

	serial_flush_input_func_t flush_input;
	serial_flush_output_func_t flush_output;
	
	serial_tcdrain_func_t tcdrain;
	
	serial_free_func_t free;
	
	serial_get_lsr_func_t get_lsr;
	serial_write_buf_func_t write_buf;
	serial_read_buf_func_t read_buf;
} serial_driver_t;

/* implemented serial drivers */
extern serial_driver_t ff232;

/* header data agreement */
typedef  struct _RSHeader_{
	char Startcode;
	char Command;
	int Param;
	int Size;
	char Flag;
	char CheckSum;
	char Endcode;
}GCC_PACKED TRSHeader, *PRSHeader;

/* extensible header data */
typedef struct _eRSHeader_{
	char Startcode;
	char Command;
	short PacketNum;
	short Index;
	int Size;
	char Flag;
	char CheckSum;
	char Endcode;
}GCC_PACKED eTRSHeader, *ePRSHeader;

/* Contrller statement */
int ConvertBaudrate(int baudrate);
int RS232_SetParameters(int port, int Baudrate, int Datasize, int Parity, int FlowControl);
int RS232_SetStopbits (int port, int Stops);
int RS232_SetTimeouts (int port, int TenthOfSeconds);

#endif
